package com.atlassian.bitbucket.event.mirror;

import javax.annotation.Nonnull;

/**
 * Base interface for events about mirrors connected to this instance.
 *
 * @since 5.0
 */
public interface MirrorEvent {

    /**
     * @return the ID of the server where this event originated
     */
    @Nonnull
    String getMirrorServerId();

    /**
     * @return the name of the server where this event is originated
     * @since 6.5
     */
    @Nonnull
    String getMirrorServerName();
}