package com.atlassian.bitbucket.event.hook;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Children of this event are fired when repository hooks are changed.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
@TransactionAware
public class RepositoryHookEvent extends ApplicationEvent {

    private final String repositoryHookKey;
    private final Scope scope;

    /**
     * @param source            the object on which the event initially occurred
     * @param repositoryHookKey the key of the repository hook
     * @param scope             scope that the hook event was created for
     * @since 5.2
     */
    protected RepositoryHookEvent(@Nonnull Object source, @Nonnull String repositoryHookKey, @Nonnull Scope scope) {
        super(source);
        this.repositoryHookKey = requireNonNull(repositoryHookKey, "repositoryHookKey");
        this.scope = requireNonNull(scope, "scope");
    }

    @Nonnull
    public String getRepositoryHookKey() {
        return repositoryHookKey;
    }

    /**
     * @return the scope that the hook event was created for
     * @since 5.2
     */
    @Nonnull
    public Scope getScope() {
        return scope;
    }
}
