package com.atlassian.bitbucket.event.commit;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised before a comment is replied to in a commit discussion. This event is synchronous, allowing
 * listeners to perform operations in the same database transaction where the reply is created.
 * <p>
 * This event is also {@link CancelableEvent cancelable}. A listener may prevent the reply from being created by
 * {@link #cancel(KeyedMessage) canceling} this event. Throwing an exception <i>will not</i> prevent the reply from
 * being created; the exception will be logged and ignored.
 *
 * @since 6.6
 */
public class CommitDiscussionCommentReplyRequestedEvent extends CommitDiscussionCancelableCommentEvent {

    public CommitDiscussionCommentReplyRequestedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                                      @Nonnull Comment comment, @Nonnull Comment parent,
                                                      @Nonnull CancelState cancelState) {
        super(source, discussion, comment, requireNonNull(parent, "parent"), CommentAction.REPLIED, cancelState);
    }
}
