package com.atlassian.bitbucket.event.commit;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when a comment is added, deleted, edited or replied to in a commit discussion.
 */
public abstract class CommitDiscussionCommentEvent extends CommitDiscussionEvent {

    private final CommentAction commentAction;
    private final Comment comment;
    private final Comment parent;

    protected CommitDiscussionCommentEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                           @Nonnull Comment comment, @Nullable Comment parent,
                                           @Nonnull CommentAction commentAction) {
        super(source, discussion);

        this.commentAction = requireNonNull(commentAction, "commentAction");
        this.comment = requireNonNull(comment, "comment");
        this.parent = parent;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return commentAction;
    }

    @Nonnull
    public Comment getComment() {
        return comment;
    }

    @Nullable
    public Comment getParent() {
        return parent;
    }
}
