package com.atlassian.bitbucket.event.commit;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised before a comment in a commit discussion is deleted. This event is synchronous, allowing
 * listeners to perform operations in the same database transaction where the comment is deleted.
 * <p>
 * This event is also {@link CancelableEvent cancelable}. A listener may prevent the comment from being deleted by
 * {@link #cancel(KeyedMessage) canceling} this event. Throwing an exception <i>will not</i> prevent the comment from
 * being deleted; the exception will be logged and ignored.
 *
 * @since 6.6
 */
public class CommitDiscussionCommentDeletionRequestedEvent extends CommitDiscussionCancelableCommentEvent {

    public CommitDiscussionCommentDeletionRequestedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                                         @Nonnull Comment comment, @Nullable Comment parent,
                                                         @Nonnull CancelState cancelState) {
        super(source, discussion, comment, parent, CommentAction.DELETED, cancelState);
    }
}
