package com.atlassian.bitbucket.event.auth;

import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a user successfully authenticates.
 */
@AsynchronousPreferred
public class AuthenticationSuccessEvent extends AbstractAuthenticationEvent {

    private final String tokenDetails;

    public AuthenticationSuccessEvent(@Nonnull Object source, @Nullable String username, @Nonnull String method) {
        this(source, username, method, null);
    }

    public AuthenticationSuccessEvent(@Nonnull Object source, @Nullable String username, @Nonnull String method,
                                      @Nullable String tokenDetails) {
        super(source, username, method);

        this.tokenDetails = tokenDetails;
    }

    /**
     * @return details describing the token that was used for authentication.
     */
    @Nullable
    public String getTokenDetails() {
        return tokenDetails;
    }
}
