package com.atlassian.bitbucket.event.auth;

import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when an attempt to authenticate fails.
 */
@AsynchronousPreferred
public class AuthenticationFailureEvent extends AbstractAuthenticationEvent {

    private final AuthenticationException exception;

    public AuthenticationFailureEvent(@Nonnull Object source, @Nullable String username, @Nonnull String method,
                                      @Nullable AuthenticationException exception) {
        super(source, username, method);

        this.exception = exception;
    }

    public AuthenticationException getException() {
        return exception;
    }
}
