package com.atlassian.bitbucket.event.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.bitbucket.audit.AuditEventConverter;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Builds {@link AuditEvent} without any additional properties.
 */
public class DefaultAuditEventConverter implements AuditEventConverter<Object> {

    @Nonnull
    @Override
    public AuditEvent convert(@Nonnull Object ignored, @Nonnull AuditEvent.Builder builder) {
        return requireNonNull(builder, "builder").build();
    }
}