package com.atlassian.bitbucket.content;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A bean representation of a path
 */
public interface Path {

    /**
     * @return the parent string - everything up to the last component, or an empty string if root
     */
    @Nullable
    String getParent();

    /**
     * @return everything after the last "/" (the last component),
     * including the extension, or an empty string if there are no components
     */
    @Nonnull
    String getName();

    /**
     * @return the file extension of the path (with no .), or null if there is
     * no file extension
     */
    @Nullable
    String getExtension();

    /**
     * @return an array of Strings representing the directories followed by a possible file name
     */
    @Nonnull
    String[] getComponents();

    /**
     * @return a string representation of the path - the components separated by "/"s
     */
    @Nonnull
    String toString();
}
