package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.util.Page;

import javax.annotation.Nonnull;
import java.io.IOException;

public class AbstractFileContentCallback implements FileContentCallback {

    @Override
    public void offerBlame(@Nonnull Page<Blame> blames) throws IOException {
    }

    @Override
    public void onBinary() throws IOException {
    }

    @Override
    public void onEnd(@Nonnull FileSummary summary) throws IOException {
    }

    /**
     * Ignores the provided line details and <i>returns {@code true}</i>, which will continue streaming.
     *
     * @param lineNumber the line number of the line in the file
     * @param line       a truncated line of code. The line character limit can be set at a system level via a system property
     * @param truncated  where the received line was truncated
     * @return {@code true}
     * @throws IOException may be thrown by derived classes
     */
    @Override
    public boolean onLine(int lineNumber, String line, boolean truncated) throws IOException {
        return true;
    }

    @Override
    public void onStart(@Nonnull FileContext context) throws IOException {
    }
}
