package com.atlassian.bitbucket.commit.graph;

import com.atlassian.bitbucket.commit.MinimalCommit;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * A node within a commit graph.
 *
 * @see TraversalCallback
 */
public interface CommitGraphNode {

    /**
     * @return the current commit represented by this node.
     */
    @Nonnull
    MinimalCommit getCommit();

    /**
     * @return the zero to many parents of the current commit.
     */
    @Nonnull
    Collection<MinimalCommit> getParents();
}
