package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Indicates no commit exists with the specified ID.
 */
public class NoSuchCommitException extends NoSuchEntityException {

    private final String commitId;

    public NoSuchCommitException(@Nonnull KeyedMessage keyedMessage, @Nonnull String commitId) {
        super(keyedMessage);

        this.commitId = requireNonNull(commitId, "commitId");
    }

    /**
     * Retrieves the ID for which no matching commit was found. If a path was supplied when attempting retrieve the
     * commit, this is the ID of the <i>starting commit</i>.
     *
     * @return the commit ID
     */
    @Nonnull
    public String getCommitId() {
        return commitId;
    }
}
