package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collection;

public interface CommitEnricher {

    /**
     * @param repository   the repository the {@link Commit commit} was retrieved from
     * @param commit       the commit to enrich
     * @param propertyKeys keys for {@link CommitIndex CommitIndex} properties to load
     * @return the enriched commit
     */
    @Nonnull
    Commit enrich(@Nonnull Repository repository, @Nonnull Commit commit, @Nullable Collection<String> propertyKeys);

    /**
     * @param repository   the repository the {@link Commit commits} were retrieved from
     * @param page         the page of commits to enrich
     * @param propertyKeys keys for {@link CommitIndex CommitIndex} properties to load
     * @return a page of enriched commits
     */
    @Nonnull
    Page<Commit> enrichPage(@Nonnull Repository repository, @Nonnull Page<Commit> page,
                            @Nullable Collection<String> propertyKeys);
}
