package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.pull.PullRequest;

import javax.annotation.Nonnull;

/**
 * Visitor for {@link Commentable} entities. Implementors are encouraged to extend
 * {@link AbstractCommentableVisitor} instead of directly implementing this interface.
 */
public interface CommentableVisitor<T> {

    T visit(@Nonnull CommitDiscussion discussion);

    T visit(@Nonnull PullRequest pullRequest);
}
