package com.atlassian.bitbucket.comment;

/**
 * Enumerates available {@link Comment comment} severities.
 *
 * @see Comment#getSeverity()
 * @since 6.7
 */
public enum CommentSeverity {

    /**
     * Type for a {@link Comment normal comment} instance.
     */
    NORMAL(100),
    /**
     * Type for a {@link Comment blocker comment} instance.
     */
    BLOCKER(200);

    private final int id;

    CommentSeverity(int id) {
        this.id = id;
    }

    @SuppressWarnings("unused") //Used by Hibernate
    public static CommentSeverity fromId(int id) {
        for (CommentSeverity value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No CommentSeverity is available for ID [" + id + "]");
    }

    public int getId() {
        return id;
    }
}