package com.atlassian.bitbucket.build;

import java.util.Locale;

public enum BuildState {

    /**
     * Indicates that a build did not complete
     *
     * @since 8.0
     */
    CANCELLED,
    FAILED,
    INPROGRESS,
    SUCCESSFUL,
    /**
     * Indicates that Bitbucket Server does not know the current status of the build
     *
     * @since 8.0
     */
    UNKNOWN;

    public static BuildState fromString(String s) {
        return valueOf(s == null ? null : s.toUpperCase(Locale.US));
    }
}
