package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A specialization of {@link AuthenticationException} that is thrown during authentication when an existing SSH key has
 * expired.
 *
 * @since 8.7
 */
public class SshAuthenticationExpiredKeyException extends AuthenticationException {

    public SshAuthenticationExpiredKeyException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public SshAuthenticationExpiredKeyException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}