package com.atlassian.bitbucket.audit;

import com.atlassian.audit.entity.AuditType;
import com.atlassian.bitbucket.event.annotation.Auditable;

/**
 * The category of actions that an audited event is grouped with.
 * <p>
 * Prior to 7.4, constants in this class were hardcoded English values. From 7.4 onward, these constants are instead
 * i18n property keys.
 *
 * @see AuditType#getCategoryI18nKey()
 * @see AuditType#getCategory()
 * @see Auditable
 * @since 7.0
 */
public class AuditCategory {

    public static final String APPS = "bitbucket.service.audit.category.apps";
    public static final String AUTHENTICATION = "bitbucket.service.audit.category.authentication";
    public static final String GLOBAL_ADMINISTRATION = "bitbucket.service.audit.category.globaladministration";
    public static final String PERMISSIONS = "bitbucket.service.audit.category.permissions";
    public static final String PROJECTS = "bitbucket.service.audit.category.projects";
    public static final String PULL_REQUESTS = "bitbucket.service.audit.category.pullrequests";
    public static final String REPOSITORIES = "bitbucket.service.audit.category.repositories";
    public static final String SEARCH = "bitbucket.service.audit.category.search";
    public static final String SECURITY = "bitbucket.service.audit.category.security";
    public static final String SYSTEM = "bitbucket.service.audit.category.system";
    public static final String USERS_AND_GROUPS = "bitbucket.service.audit.category.usersandgroups";

    private AuditCategory() {
        throw new UnsupportedOperationException(getClass().getName() + " is not intended to be instantiated.");
    }
}
