package com.atlassian.bitbucket.attachment;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * Represents an attachment
 *
 * @since 7.0
 */
public interface Attachment {

    /**
     * @return the filename of the attachment.
     */
    @Nonnull
    String getFilename();

    /**
     * @return an unique identifier for the attachment.
     */
    long getId();

    /**
     * @return the repository for the attachment.
     */
    @Nonnull
    Repository getRepository();
}
