package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.UserAdminService;

import javax.annotation.Nonnull;

/**
 * Exception thrown when no unique user identifier could be generated.
 *
 * @see UserAdminService#eraseUser(String)
 * @since 5.16
 */
public class NoUniqueUserIdentifierException extends ServiceException {

    public NoUniqueUserIdentifierException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
