package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown to indicate an entity's internal state was not acceptable for performing a requested operation. Where
 * possible, specialised subclasses should be thrown, rather than this generic base class. Additionally, because
 * the contract for this exception is intentionally vague, methods which may throw it should explicitly document
 * the triggering conditions.
 */
public class IllegalEntityStateException extends ServiceException {

    public IllegalEntityStateException(@Nonnull KeyedMessage message) {
        super(message);
    }

    /**
     * @param message a message describing the failure
     * @param cause   the cause of the failure, which may be {@code null} for top-level failures
     * @since 6.6
     */
    public IllegalEntityStateException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
