/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.property;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PropertyMap
implements Map<String, Object> {
    public static final PropertyMap EMPTY = new PropertyMap(Collections.emptyMap());
    private final Map<String, Object> delegate;

    private PropertyMap(Map<String, Object> delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public <T> T getAs(@Nonnull String key, @Nonnull Class<T> expectedType) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(expectedType, "expectedType");
        return expectedType.cast(this.get(key));
    }

    @Nullable
    public <E, I extends Iterable<E>> I getAs(@Nonnull String key, @Nonnull Class<I> iterableType, @Nonnull Class<E> elementType) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(iterableType, "iterableType");
        Objects.requireNonNull(elementType, "elementType");
        return (I)((Iterable)iterableType.cast(this.get(key)));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("PropertiesMap is immutable");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("PropertiesMap is immutable");
    }

    @Override
    public void putAll(@Nonnull Map<? extends String, ?> other) {
        throw new UnsupportedOperationException("PropertiesMap is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("PropertiesMap is immutable");
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    @Nonnull
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyMap) {
            return this.delegate.equals(((PropertyMap)obj).delegate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static class Builder {
        private final HashMap<String, Object> map = new HashMap();

        public Builder property(@Nonnull String key, @Nonnull Object value) {
            this.map.put(key, value);
            return this;
        }

        public Builder properties(@Nonnull Map<String, ?> properties) {
            this.map.putAll(Objects.requireNonNull(properties, "properties"));
            return this;
        }

        public PropertyMap build() {
            return new PropertyMap(Collections.unmodifiableMap(this.map));
        }
    }
}

