/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbstractChangesCommandParameters
extends AbstractCommandParameters {
    private final int maxChanges;
    private final Set<String> paths;

    protected AbstractChangesCommandParameters(AbstractBuilder<?> builder) {
        this.maxChanges = ((AbstractBuilder)builder).maxChanges;
        this.paths = ((AbstractBuilder)builder).paths.build();
    }

    public int getMaxChanges() {
        return this.maxChanges;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    @Nonnull
    protected ChangeContext toContext(@Nonnull ChangeContext.Builder builder) {
        return Objects.requireNonNull(builder, "builder").maxChanges(this.getMaxChanges()).build();
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private int maxChanges;

        protected AbstractBuilder() {
        }

        @Nonnull
        public B maxChanges(int value) {
            this.maxChanges = value;
            return this.self();
        }

        @Nonnull
        public B path(@Nullable String value) {
            AbstractChangesCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable Iterable<String> values) {
            AbstractChangesCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable String value, String ... values) {
            AbstractChangesCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

