/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.mirror;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class MirrorSyncCommandParameters
extends AbstractCommandParameters {
    private final Map<String, String> environment;
    private final boolean includePrivateRefs;
    private final String password;
    private final File privateKeyFile;
    private final boolean prune;
    private final Set<String> refspecs;
    private final String remoteUrl;
    private final String username;
    private final boolean withTags;

    private MirrorSyncCommandParameters(Builder builder) {
        this.environment = builder.environment.build();
        this.includePrivateRefs = builder.includePrivateRefs;
        this.password = builder.password;
        this.privateKeyFile = builder.privateKeyFile;
        this.remoteUrl = builder.remoteUrl;
        this.username = builder.username;
        this.refspecs = builder.refspecs.build();
        this.prune = builder.prune;
        this.withTags = builder.withTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorSyncCommandParameters that = (MirrorSyncCommandParameters)o;
        return this.includePrivateRefs == that.includePrivateRefs && this.prune == that.prune && this.withTags == that.withTags && Objects.equals(this.password, that.password) && Objects.equals(this.privateKeyFile, that.privateKeyFile) && Objects.equals(this.refspecs, that.refspecs) && Objects.equals(this.remoteUrl, that.remoteUrl) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.includePrivateRefs, this.password, this.privateKeyFile, this.prune, this.refspecs, this.remoteUrl, this.username, this.withTags);
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Nonnull
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Nonnull
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Nonnull
    public Optional<File> getPrivateKey() {
        return Optional.ofNullable(this.privateKeyFile);
    }

    @Nonnull
    public Set<String> getRefspecs() {
        return this.refspecs;
    }

    @Nonnull
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public boolean isIncludePrivateRefs() {
        return this.includePrivateRefs;
    }

    public boolean isPrune() {
        return this.prune;
    }

    public boolean isWithTags() {
        return this.withTags;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("includePrivateRefs", this.includePrivateRefs).add("password", (Object)this.password).add("privateKeyFile", (Object)this.privateKeyFile).add("prune", this.prune).add("refspecs", this.refspecs).add("remoteUrl", (Object)this.remoteUrl).add("username", (Object)this.username).add("withTags", this.withTags).toString();
    }

    public static class Builder {
        private final String remoteUrl;
        private final ImmutableMap.Builder<String, String> environment;
        private final ImmutableSet.Builder<String> refspecs;
        private boolean includePrivateRefs;
        private String password;
        private File privateKeyFile;
        private boolean prune;
        private String username;
        private boolean withTags;

        public Builder(@Nonnull String remoteUrl) {
            this.remoteUrl = MirrorSyncCommandParameters.requireNonBlank(remoteUrl, "remoteUrl");
            this.environment = ImmutableMap.builder();
            this.includePrivateRefs = true;
            this.prune = true;
            this.refspecs = ImmutableSet.builder();
        }

        public Builder(@Nonnull MirrorSyncCommandParameters mirrorSyncCommandParameters) {
            this.environment = ImmutableMap.builder().putAll(mirrorSyncCommandParameters.environment);
            this.remoteUrl = mirrorSyncCommandParameters.getRemoteUrl();
            this.includePrivateRefs = mirrorSyncCommandParameters.isIncludePrivateRefs();
            this.password = mirrorSyncCommandParameters.getPassword().orElse(null);
            this.privateKeyFile = mirrorSyncCommandParameters.getPrivateKey().orElse(null);
            this.prune = mirrorSyncCommandParameters.isPrune();
            this.username = mirrorSyncCommandParameters.getUsername().orElse(null);
            this.withTags = mirrorSyncCommandParameters.isWithTags();
            this.refspecs = ImmutableSet.builder();
            this.refspecs.addAll(mirrorSyncCommandParameters.getRefspecs());
        }

        @Nonnull
        public MirrorSyncCommandParameters build() {
            return new MirrorSyncCommandParameters(this);
        }

        @Nonnull
        public Builder includePrivateRefs(boolean value) {
            this.includePrivateRefs = value;
            return this;
        }

        @Nonnull
        public Builder withTags(boolean value) {
            this.withTags = value;
            return this;
        }

        @Nonnull
        public Builder password(@Nonnull String value) {
            this.password = Objects.requireNonNull(value, "password");
            return this;
        }

        @Nonnull
        public Builder privateKey(@Nonnull File value) {
            this.privateKeyFile = Objects.requireNonNull(value, "privateKeyFile");
            return this;
        }

        @Nonnull
        public Builder privateKey(@Nonnull Path value) {
            return this.privateKey(Objects.requireNonNull(value, "privateKeyFile").toFile());
        }

        @Nonnull
        public Builder prune(boolean value) {
            this.prune = value;
            return this;
        }

        @Nonnull
        public Builder refspecs(@Nonnull Iterable<String> values) {
            MirrorSyncCommandParameters.addIf(Objects::nonNull, this.refspecs, values);
            return this;
        }

        @Nonnull
        public Builder username(@Nonnull String value) {
            this.username = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder withEnvironment(@Nonnull String name, @Nonnull String value) {
            this.environment.put((Object)MirrorSyncCommandParameters.requireNonBlank(name, "name"), (Object)MirrorSyncCommandParameters.requireNonBlank(value, "value"));
            return this;
        }
    }
}

