/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.reopened")
public class PullRequestReopenedEvent
extends PullRequestEvent {
    private final String previousFromHash;
    private final String previousToHash;

    public PullRequestReopenedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull String previousFromHash, @Nonnull String previousToHash) {
        super(source, pullRequest, PullRequestAction.REOPENED);
        this.previousFromHash = (String)Preconditions.checkNotNull((Object)previousFromHash, (Object)"previousFromHash");
        this.previousToHash = (String)Preconditions.checkNotNull((Object)previousToHash, (Object)"previousToHash");
    }

    @Nonnull
    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return this.previousToHash;
    }
}

