/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.audit;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

@AsynchronousPreferred
public class AuditEvent
extends ApplicationEvent {
    private final AuditEntry entry;
    private final Set<String> channels;
    private final Priority priority;

    public AuditEvent(@Nonnull Object source, @Nonnull AuditEntry entry, @Nonnull Set<String> channels, Priority priority) {
        super(Preconditions.checkNotNull((Object)source, (Object)"source"));
        this.priority = priority;
        this.entry = (AuditEntry)Preconditions.checkNotNull((Object)entry, (Object)"entry");
        this.channels = Collections.unmodifiableSet((Set)Preconditions.checkNotNull(channels, (Object)"channels"));
    }

    @Nonnull
    public AuditEntry getEntry() {
        return this.entry;
    }

    @Nonnull
    public Set<String> getChannels() {
        return this.channels;
    }

    @Nonnull
    public Priority getPriority() {
        return this.priority;
    }
}

