/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.RefChangeDetails;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleRefChangeDetails
implements RefChangeDetails {
    private final List<Commit> commits;
    private final int totalCommits;

    public SimpleRefChangeDetails(Builder builder) {
        this.commits = builder.commits.build();
        this.totalCommits = builder.totalCommits;
    }

    @Override
    @Nonnull
    public List<Commit> getCommits() {
        return this.commits;
    }

    @Override
    public int getTotal() {
        return this.totalCommits;
    }

    public static class Builder
    extends BuilderSupport {
        private ImmutableList.Builder<Commit> commits = new ImmutableList.Builder();
        private int totalCommits;

        @Nonnull
        public RefChangeDetails build() {
            return new SimpleRefChangeDetails(this);
        }

        @Nonnull
        public Builder commits(@Nonnull Iterable<Commit> value) {
            Builder.addIf(Objects::nonNull, this.commits, value);
            return this;
        }

        @Nonnull
        public Builder totalCommits(int value) {
            this.totalCommits = value;
            return this;
        }
    }
}

