/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.migration.RepositorySelector;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class RepositoriesExportRequest {
    private final Set<RepositorySelector> includes;

    private RepositoriesExportRequest(Builder builder) {
        this.includes = builder.includes.build();
    }

    @Nonnull
    public Set<RepositorySelector> getIncludes() {
        return this.includes;
    }

    public static final class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<RepositorySelector> includes = ImmutableSet.builder();

        @Nonnull
        public RepositoriesExportRequest build() {
            return new RepositoriesExportRequest(this);
        }

        @Nonnull
        public Builder include(RepositorySelector value) {
            Builder.addIf(Objects::nonNull, this.includes, value);
            return this;
        }

        @Nonnull
        public Builder includes(Iterable<RepositorySelector> values) {
            Builder.addIf(Objects::nonNull, this.includes, values);
            return this;
        }
    }
}

