/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MigrationJobMessageSearchRequest {
    private final long jobId;
    private final Set<JobMessageSeverity> severities;
    private final String subject;

    private MigrationJobMessageSearchRequest(Builder builder) {
        this.jobId = builder.jobId;
        this.severities = builder.severities;
        this.subject = builder.subject;
    }

    public long getJobId() {
        return this.jobId;
    }

    @Nonnull
    public Set<JobMessageSeverity> getSeverities() {
        return this.severities;
    }

    @Nonnull
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public static class Builder
    extends BuilderSupport {
        private final long jobId;
        private EnumSet<JobMessageSeverity> severities;
        private String subject;

        public Builder(long jobId) {
            this.jobId = jobId;
            this.severities = EnumSet.noneOf(JobMessageSeverity.class);
        }

        @Nonnull
        public MigrationJobMessageSearchRequest build() {
            return new MigrationJobMessageSearchRequest(this);
        }

        @Nonnull
        public Builder severity(@Nullable JobMessageSeverity value) {
            Builder.addIf(Objects::nonNull, this.severities, value);
            return this;
        }

        @Nonnull
        public Builder severities(@Nonnull Iterable<JobMessageSeverity> values) {
            Builder.addIf(Objects::nonNull, this.severities, values);
            return this;
        }

        @Nonnull
        public Builder subject(@Nullable String value) {
            this.subject = value;
            return this;
        }
    }
}

