/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.MinimalRepositoryCommit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nonnull;

public class BulkCommitsRequest {
    private static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final Map<Repository, Set<String>> commits;
    private final boolean ignoringMissing;
    private final int maxMessageLength;

    private BulkCommitsRequest(Builder builder) {
        this.commits = builder.commits.build().asMap();
        this.ignoringMissing = builder.ignoringMissing;
        this.maxMessageLength = builder.maxMessageLength;
    }

    @Nonnull
    public Map<Repository, Set<String>> getCommits() {
        return this.commits;
    }

    @Nonnull
    public OptionalInt getMaxMessageLength() {
        return this.maxMessageLength == -1 ? OptionalInt.empty() : OptionalInt.of(this.maxMessageLength);
    }

    public boolean isIgnoringMissing() {
        return this.ignoringMissing;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSetMultimap.Builder<Repository, String> commits = ImmutableSetMultimap.builder();
        private boolean ignoringMissing;
        private int maxMessageLength = -1;

        @Nonnull
        public BulkCommitsRequest build() {
            return new BulkCommitsRequest(this);
        }

        @Nonnull
        public Builder commit(@Nonnull MinimalRepositoryCommit value) {
            this.commits.put((Object)Objects.requireNonNull(value, "commit").getRepository(), (Object)value.getId());
            return this;
        }

        @Nonnull
        public Builder commit(@Nonnull Repository repository, @Nonnull String commit) {
            this.commits.put((Object)Objects.requireNonNull(repository, "repository"), (Object)Builder.requireNonBlank(commit, "commit"));
            return this;
        }

        @Nonnull
        public Builder commits(@Nonnull Iterable<MinimalRepositoryCommit> values) {
            Objects.requireNonNull(values, "commits").forEach(this::commit);
            return this;
        }

        @Nonnull
        public Builder commits(@Nonnull Repository repository, @Nonnull Iterable<String> value) {
            this.commits.putAll((Object)Objects.requireNonNull(repository, "repository"), Objects.requireNonNull(value, "commits"));
            return this;
        }

        @Nonnull
        public Builder ignoreMissing(boolean value) {
            this.ignoringMissing = value;
            return this;
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }
    }
}

