/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.compare;

import com.atlassian.bitbucket.compare.CompareDiffRequest;
import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class CompareRequest {
    private final CompareRef fromRef;
    private final CompareRef toRef;

    private CompareRequest(@Nonnull Builder builder) {
        this.fromRef = builder.fromRef;
        this.toRef = builder.toRef;
    }

    @Nonnull
    public CompareRef getFromRef() {
        return this.fromRef;
    }

    @Nonnull
    public CompareRef getToRef() {
        return this.toRef;
    }

    public static class Builder {
        private CompareRef fromRef;
        private CompareRef toRef;

        public Builder() {
        }

        public Builder(@Nonnull CompareDiffRequest request) {
            this.fromRef = ((CompareDiffRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getFromRef();
            this.toRef = request.getToRef();
        }

        public Builder(@Nonnull PullRequest pullRequest) {
            this.fromRef = new CompareRef(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getFromRef());
            this.toRef = new CompareRef(pullRequest.getToRef());
        }

        @Nonnull
        public CompareRequest build() {
            Preconditions.checkArgument((this.fromRef != null && this.toRef != null ? 1 : 0) != 0, (Object)"both a source and target ref are required");
            return new CompareRequest(this);
        }

        @Nonnull
        public Builder fromRef(@Nonnull CompareRef fromRef) {
            this.fromRef = (CompareRef)Preconditions.checkNotNull((Object)fromRef, (Object)"fromRef");
            return this;
        }

        @Nonnull
        public Builder fromRef(@Nonnull String id, @Nonnull Repository repository) {
            return this.fromRef(new CompareRef(id, repository));
        }

        @Nonnull
        public Builder toRef(@Nonnull CompareRef toRef) {
            this.toRef = (CompareRef)Preconditions.checkNotNull((Object)toRef, (Object)"toRef");
            return this;
        }

        @Nonnull
        public Builder toRef(@Nonnull String id, @Nonnull Repository repository) {
            return this.toRef(new CompareRef(id, repository));
        }
    }
}

