/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommentSearchRequest {
    private final CommentThreadDiffAnchorState anchorState;
    private final Commentable commentable;
    private final Set<CommentThreadDiffAnchorType> diffTypes;
    private final String fromHash;
    private final String path;
    private final String toHash;

    private CommentSearchRequest(@Nonnull Builder builder) {
        this.anchorState = builder.anchorState;
        this.commentable = builder.commentable;
        this.diffTypes = builder.diffTypes.build();
        this.fromHash = builder.fromHash;
        this.path = builder.path;
        this.toHash = builder.toHash;
    }

    @Nonnull
    public CommentThreadDiffAnchorState getAnchorState() {
        return this.anchorState;
    }

    @Nonnull
    public Commentable getCommentable() {
        return this.commentable;
    }

    @Nonnull
    public Set<CommentThreadDiffAnchorType> getDiffTypes() {
        return this.diffTypes;
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getToHash() {
        return this.toHash;
    }

    public static class Builder
    extends BuilderSupport {
        private final Commentable commentable;
        private final ImmutableSet.Builder<CommentThreadDiffAnchorType> diffTypes;
        private CommentThreadDiffAnchorState anchorState = CommentThreadDiffAnchorState.ACTIVE;
        private String fromHash;
        private String path;
        private String toHash;

        public Builder(@Nonnull Commentable commentable) {
            this.commentable = Objects.requireNonNull(commentable, "commentable");
            this.diffTypes = ImmutableSet.builder();
        }

        @Nonnull
        public Builder anchorState(@Nonnull CommentThreadDiffAnchorState value) {
            this.anchorState = Objects.requireNonNull(value, "anchorState");
            return this;
        }

        @Nonnull
        public CommentSearchRequest build() {
            return new CommentSearchRequest(this);
        }

        @Nonnull
        public Builder diffType(@Nullable CommentThreadDiffAnchorType value) {
            Builder.addIf(Objects::nonNull, this.diffTypes, value);
            return this;
        }

        @Nonnull
        public Builder diffTypes(@Nullable Iterable<CommentThreadDiffAnchorType> values) {
            Builder.addIf(Objects::nonNull, this.diffTypes, values);
            return this;
        }

        @Nonnull
        public Builder fromHash(@Nullable String value) {
            this.fromHash = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public Builder toHash(@Nullable String value) {
            this.toHash = value;
            return this;
        }
    }
}

