/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.AddCommentRequest;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddFileCommentRequest
extends AddCommentRequest {
    private final CommentThreadDiffAnchorType diffType;
    private final String fromHash;
    private final String path;
    private final String srcPath;
    private final String toHash;

    protected AddFileCommentRequest(@Nonnull AbstractFileBuilder builder) {
        super(builder);
        this.diffType = builder.diffType;
        this.fromHash = builder.fromHash;
        this.path = builder.path;
        this.srcPath = builder.srcPath;
        this.toHash = builder.toHash;
    }

    @Nonnull
    public CommentThreadDiffAnchorType getDiffType() {
        return this.diffType;
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getSrcPath() {
        return this.srcPath;
    }

    @Nullable
    public String getToHash() {
        return this.toHash;
    }

    protected static abstract class AbstractFileBuilder<B extends AbstractFileBuilder<B, R>, R extends AddFileCommentRequest>
    extends AddCommentRequest.AbstractBuilder<B, R> {
        private final CommentThreadDiffAnchorType diffType;
        private String fromHash;
        private String path;
        private String srcPath;
        private String toHash;

        public AbstractFileBuilder(@Nonnull Commentable commentable, @Nonnull String text, @Nonnull CommentThreadDiffAnchorType diffType, @Nonnull String path) {
            super(commentable, text);
            this.diffType = Objects.requireNonNull(diffType, "diffType");
            this.path = AbstractFileBuilder.requireNonBlank(path, "path");
        }

        @Nonnull
        public B fromHash(@Nullable String value) {
            this.fromHash = value;
            return (B)((AbstractFileBuilder)this.self());
        }

        @Nonnull
        public B srcPath(@Nullable String value) {
            this.srcPath = value;
            return (B)((AbstractFileBuilder)this.self());
        }

        @Nonnull
        public B toHash(@Nullable String value) {
            this.toHash = value;
            return (B)((AbstractFileBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractFileBuilder<Builder, AddFileCommentRequest> {
        public Builder(@Nonnull Commentable commentable, @Nonnull String text, @Nonnull CommentThreadDiffAnchorType diffType, @Nonnull String path) {
            super(commentable, text, diffType, path);
        }

        @Override
        @Nonnull
        public AddFileCommentRequest build() {
            return new AddFileCommentRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

