/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.mirror;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MirrorSyncCommandParameters
extends AbstractCommandParameters {
    private final boolean includePrivateRefs;
    private final String password;
    private final File privateKeyFile;
    private final String remoteUrl;
    private final String username;

    private MirrorSyncCommandParameters(Builder builder) {
        this.includePrivateRefs = builder.includePrivateRefs;
        this.password = builder.password;
        this.privateKeyFile = builder.privateKeyFile;
        this.remoteUrl = builder.remoteUrl;
        this.username = builder.username;
    }

    @Nonnull
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Nonnull
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Nonnull
    public Optional<File> getPrivateKey() {
        return Optional.ofNullable(this.privateKeyFile);
    }

    @Nonnull
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public boolean isIncludePrivateRefs() {
        return this.includePrivateRefs;
    }

    public static class Builder {
        private final String remoteUrl;
        private boolean includePrivateRefs;
        private String password;
        private File privateKeyFile;
        private String username;

        public Builder(@Nonnull String remoteUrl) {
            this.remoteUrl = MirrorSyncCommandParameters.requireNonBlank(remoteUrl, "remoteUrl");
            this.includePrivateRefs = true;
        }

        @Nonnull
        public MirrorSyncCommandParameters build() {
            return new MirrorSyncCommandParameters(this);
        }

        @Nonnull
        public Builder includePrivateRefs(boolean value) {
            this.includePrivateRefs = value;
            return this;
        }

        @Nonnull
        public Builder password(@Nonnull String value) {
            this.password = Objects.requireNonNull(value, "password");
            return this;
        }

        @Nonnull
        public Builder privateKey(@Nonnull File value) {
            this.privateKeyFile = Objects.requireNonNull(value, "privateKeyFile");
            return this;
        }

        @Nonnull
        public Builder privateKey(@Nonnull Path value) {
            return this.privateKey(Objects.requireNonNull(value, "privateKeyFile").toFile());
        }

        @Nonnull
        public Builder username(@Nonnull String value) {
            this.username = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

