/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.PageRequest;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Page<T> {
    public int getStart();

    public int getSize();

    public int getLimit();

    public boolean getIsLastPage();

    @Nonnull
    public Iterable<T> getValues();

    @Nullable
    public PageRequest getNextPageRequest();

    @Nonnull
    public SortedMap<Integer, T> getOrdinalIndexedValues();

    @Nonnull
    default public Stream<T> stream() {
        return MoreStreams.streamIterable(this.getValues());
    }

    @Nonnull
    public <E> Page<E> transform(@Nonnull Function<? super T, ? extends E> var1);
}

