/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.audit;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditEntryBuilder
extends BuilderSupport {
    private String action;
    private String details;
    private Project project;
    private Repository repository;
    private String sourceIpAddress;
    private String target;
    private long timestamp;
    private ApplicationUser user;

    @Nonnull
    public AuditEntryBuilder action(@Nonnull Class<?> value) {
        return this.action(Objects.requireNonNull(value, "action").getSimpleName());
    }

    @Nonnull
    public AuditEntryBuilder action(@Nonnull String value) {
        Objects.requireNonNull(value, "action");
        if (value.startsWith("Analytics") && !"Analytics".equals(value)) {
            value = value.substring(9);
        }
        this.action = AuditEntryBuilder.checkNotBlank(value, "action");
        return this;
    }

    @Nonnull
    public AuditEntry build() {
        return new SimpleAuditEntry(this);
    }

    @Nonnull
    public AuditEntryBuilder details(@Nullable String value) {
        this.details = value;
        return this;
    }

    @Nonnull
    public AuditEntryBuilder project(@Nullable Project value) {
        this.project = value;
        return this;
    }

    @Nonnull
    public AuditEntryBuilder repository(@Nullable Repository value) {
        this.repository = value;
        if (value != null) {
            this.project = value.getProject();
        }
        return this;
    }

    @Nonnull
    public AuditEntryBuilder sourceIpAddress(@Nullable String value) {
        this.sourceIpAddress = value;
        return this;
    }

    @Nonnull
    public AuditEntryBuilder target(@Nonnull String value) {
        this.target = Objects.requireNonNull(value, "value");
        return this;
    }

    @Nonnull
    public AuditEntryBuilder timestamp(@Nonnull Date value) {
        this.timestamp = Objects.requireNonNull(value, "timestamp").getTime();
        return this;
    }

    @Nonnull
    public AuditEntryBuilder timestamp(long value) {
        this.timestamp = value;
        return this;
    }

    @Nonnull
    public AuditEntryBuilder user(@Nullable ApplicationUser value) {
        this.user = value;
        return this;
    }

    private static class SimpleAuditEntry
    implements AuditEntry {
        private final Project project;
        private final Repository repository;
        private final ApplicationUser user;
        private final String details;
        private final long timestamp;
        private final String action;
        private final String sourceIpAddress;
        private final String target;

        private SimpleAuditEntry(AuditEntryBuilder builder) {
            this.action = builder.action;
            this.details = builder.details;
            this.project = builder.project;
            this.repository = builder.repository;
            this.sourceIpAddress = builder.sourceIpAddress;
            this.target = builder.target;
            this.timestamp = builder.timestamp;
            this.user = builder.user;
        }

        @Override
        @Nonnull
        public String getAction() {
            return this.action;
        }

        @Override
        public String getDetails() {
            return this.details;
        }

        @Override
        public Project getProject() {
            return this.project;
        }

        @Override
        public Repository getRepository() {
            return this.repository;
        }

        @Override
        @Nonnull
        public Date getTimestamp() {
            return new Date(this.timestamp);
        }

        @Override
        public String getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        @Override
        @Nonnull
        public String getTarget() {
            return this.target;
        }

        @Override
        public ApplicationUser getUser() {
            return this.user;
        }
    }
}

