/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryRef;
import com.atlassian.bitbucket.repository.SimpleMinimalRepositoryRef;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleRepositoryRef
extends SimpleMinimalRepositoryRef
implements RepositoryRef {
    private final String latestCommit;

    private SimpleRepositoryRef(@Nonnull Builder builder) {
        super(builder);
        this.latestCommit = Objects.requireNonNull(builder.latestCommit, "latestCommit");
    }

    @Override
    @Nonnull
    public String getLatestCommit() {
        return this.latestCommit;
    }

    public static class Builder
    extends SimpleMinimalRepositoryRef.AbstractBuilder<Builder, SimpleRepositoryRef> {
        private String latestCommit;

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull Repository repository, @Nonnull Ref ref) {
            super(repository, ref);
            this.latestCommit = ref.getLatestCommit();
        }

        public Builder(@Nonnull SimpleRepositoryRef ref) {
            super(ref);
            this.latestCommit = ref.getLatestCommit();
        }

        @Override
        @Nonnull
        public SimpleRepositoryRef build() {
            return new SimpleRepositoryRef(this);
        }

        @Nonnull
        public Builder latestCommit(@Nonnull String value) {
            this.latestCommit = Objects.requireNonNull(value, "latestCommit");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

