/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.permission.PermissionEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public abstract class RepositoryPermissionEvent
extends PermissionEvent {
    private final Repository repository;

    protected RepositoryPermissionEvent(Object source, Permission permission, Repository repository, String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, affectedGroup, affectedUser);
        Preconditions.checkArgument((boolean)(Strings.isNullOrEmpty((String)affectedGroup) ^ affectedUser == null), (String)"Either a user or group can be affected, not both or neither. user=%s, group=%s", (Object[])new Object[]{affectedUser, affectedGroup});
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class), (Object)"Require a repository permission");
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
    }

    public Repository getRepository() {
        return this.repository;
    }
}

