/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.hook.repository.AbstractRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileEditHookRequest
extends AbstractRepositoryHookRequest {
    private final Branch branch;
    private final InputSupplier<InputStream> content;
    private final String message;
    private final String path;
    private final RefChange refChange;
    private final String sourceCommitId;

    private FileEditHookRequest(Builder builder) {
        super(builder);
        this.branch = builder.branch;
        this.content = builder.content;
        this.message = builder.message;
        this.path = builder.path;
        this.sourceCommitId = builder.sourceCommitId;
        this.refChange = builder.dryRun && builder.fromHash == null ? null : new SimpleRefChange.Builder().ref(this.branch).fromHash(Objects.requireNonNull(builder.fromHash, "fromHash")).toHash(Objects.requireNonNull(builder.toHash, "toHash")).type(RefChangeType.UPDATE).build();
    }

    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Nonnull
    public InputSupplier<InputStream> getContent() {
        return this.content;
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChange == null ? Collections.emptyList() : Collections.singleton(this.refChange);
    }

    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Optional<String> getSourceCommitId() {
        return Optional.ofNullable(this.sourceCommitId);
    }

    public static class Builder
    extends AbstractRepositoryHookRequest.AbstractBuilder<Builder> {
        private final Branch branch;
        private final InputSupplier<InputStream> content;
        private final String path;
        private String fromHash;
        private String toHash;
        private String message;
        private String sourceCommitId;

        public Builder(@Nonnull Repository repository, @Nonnull Branch branch, @Nonnull String path, @Nonnull InputSupplier<InputStream> content) {
            super(repository, StandardRepositoryHookTrigger.FILE_EDIT);
            this.branch = Objects.requireNonNull(branch, "branch");
            this.content = Objects.requireNonNull(content, "content");
            this.path = Objects.requireNonNull(path, "path");
            this.fromHash = this.toHash = branch.getLatestCommit();
        }

        @Nonnull
        public FileEditHookRequest build() {
            return new FileEditHookRequest(this);
        }

        @Nonnull
        public Builder fromHash(@Nullable String value) {
            this.fromHash = value;
            return this.self();
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder sourceCommitId(@Nullable String value) {
            this.sourceCommitId = value;
            return this.self();
        }

        @Nonnull
        public Builder toHash(@Nullable String value) {
            this.toHash = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

