/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.util.BuilderSupport;
import javax.annotation.Nonnull;

public class ContentTreeContext {
    private final String commitId;
    private final boolean recursive;

    private ContentTreeContext(Builder builder) {
        this.commitId = builder.commitId;
        this.recursive = builder.recursive;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private boolean recursive;

        public Builder(@Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank(commitId, "commitId");
        }

        @Nonnull
        public ContentTreeContext build() {
            return new ContentTreeContext(this);
        }

        @Nonnull
        public Builder recursive(boolean value) {
            this.recursive = value;
            return this;
        }
    }
}

