/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitRequest {
    private static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final String commitId;
    private final int maxMessageLength;
    private final String path;
    private final Set<String> propertyKeys;
    private final Repository repository;

    private CommitRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.path = builder.path;
        this.propertyKeys = builder.propertyKeys.build();
        this.repository = builder.repository;
        this.maxMessageLength = builder.maxMessageLength;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.propertyKeys;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final ImmutableSet.Builder<String> propertyKeys;
        private final Repository repository;
        private int maxMessageLength;
        private String path;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank(commitId, "commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.propertyKeys = ImmutableSet.builder();
            this.maxMessageLength = -1;
        }

        @Nonnull
        public CommitRequest build() {
            return new CommitRequest(this);
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public Builder propertyKey(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value, values);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, values);
            return this;
        }
    }
}

