/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.commit.CommitsRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitsCommandParameters
extends AbstractCommandParameters {
    private final boolean all;
    private final Set<String> excludes;
    private final Set<String> includes;
    private final Set<String> paths;
    private final Repository secondaryRepository;
    private final boolean traversing;
    private final boolean withMessages;

    private CommitsCommandParameters(Builder builder) {
        this.all = builder.all;
        this.excludes = builder.traversing ? builder.excludes.build() : Collections.emptySet();
        this.includes = this.all ? Collections.emptySet() : builder.includes.build();
        this.paths = builder.paths.build();
        this.secondaryRepository = builder.secondaryRepository;
        this.traversing = builder.traversing;
        this.withMessages = builder.withMessages;
    }

    @Nonnull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isTraversing() {
        return this.traversing;
    }

    public boolean hasExcludes() {
        return !this.excludes.isEmpty();
    }

    public boolean hasIncludes() {
        return !this.includes.isEmpty();
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    public boolean hasSecondaryRepository() {
        return this.secondaryRepository != null;
    }

    public boolean isWithMessages() {
        return this.withMessages;
    }

    @Nonnull
    public CommitContext toContext() {
        return new CommitContext.Builder().build();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private boolean all;
        private Repository secondaryRepository;
        private boolean traversing = true;
        private boolean withMessages = true;

        public Builder() {
        }

        public Builder(@Nonnull CommitsBetweenRequest request) {
            this();
            this.exclude(Objects.requireNonNull(request, "request").getExcludes()).include(request.getIncludes()).secondaryRepository(request.getSecondaryRepository()).paths(request.getPaths());
        }

        public Builder(@Nonnull CommitsRequest request) {
            this();
            this.include(Objects.requireNonNull(request, "request").getCommitId(), new String[0]).paths(request.getPaths());
        }

        @Nonnull
        public Builder all(boolean value) {
            this.all = value;
            return this;
        }

        @Nonnull
        public CommitsCommandParameters build() {
            return new CommitsCommandParameters(this);
        }

        @Nonnull
        public Builder exclude(@Nullable Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.excludes, values);
            return this;
        }

        @Nonnull
        public Builder exclude(@Nullable String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.excludes, value, values);
            return this;
        }

        @Nonnull
        public Builder include(@Nullable Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.includes, values);
            return this;
        }

        @Nonnull
        public Builder include(@Nullable String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.includes, value, values);
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }

        @Nonnull
        public Builder traverse(boolean value) {
            this.traversing = value;
            return this;
        }

        @Nonnull
        public Builder withMessages(boolean value) {
            this.withMessages = value;
            return this;
        }
    }
}

