/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AbstractMergeCommandParameters
extends AbstractCommandParameters {
    private final ApplicationUser author;
    private final boolean dryRun;
    private final String message;

    protected AbstractMergeCommandParameters(AbstractBuilder<?> builder) {
        this.author = ((AbstractBuilder)builder).author;
        this.dryRun = ((AbstractBuilder)builder).dryRun;
        this.message = ((AbstractBuilder)builder).message;
    }

    @Nonnull
    public ApplicationUser getAuthor() {
        return this.author;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private ApplicationUser author;
        private boolean dryRun;
        private String message;

        @Nonnull
        public B author(@Nonnull ApplicationUser value) {
            this.author = (ApplicationUser)Preconditions.checkNotNull((Object)value);
            return this.self();
        }

        @Nonnull
        public B dryRun(boolean value) {
            this.dryRun = value;
            return this.self();
        }

        @Nonnull
        public B message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();

        protected void validate() {
            if (this.author == null) {
                throw new IllegalStateException("When performing or testing a merge, an author is required");
            }
            if (StringUtils.isBlank((CharSequence)this.author.getDisplayName())) {
                throw new IllegalStateException("When performing a merge, the author must have a display name");
            }
            if (StringUtils.isBlank((CharSequence)this.author.getEmailAddress())) {
                throw new IllegalStateException("When performing a merge, the author must have an e-mail address");
            }
            if (!this.dryRun && StringUtils.isEmpty((CharSequence)this.message)) {
                throw new IllegalStateException("When performing a merge, a commit message is required");
            }
        }
    }
}

