/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestSearchRequest {
    public static final int MAXIMUM_BRANCHES_TO_SEARCH = 100;
    private final Collection<String> fromRefIds;
    private final Integer fromRepositoryId;
    private final PullRequestOrder order;
    private final Collection<PullRequestParticipantRequest> participants;
    private final PullRequestState state;
    private final Collection<String> toRefIds;
    private final Integer toRepositoryId;
    private final boolean withProperties;

    private PullRequestSearchRequest(Builder builder) {
        this.fromRefIds = builder.fromRefIds.build();
        this.fromRepositoryId = builder.fromRepositoryId;
        this.order = builder.order;
        this.participants = builder.participants.build();
        this.state = builder.state;
        this.toRefIds = builder.toRefIds.build();
        this.toRepositoryId = builder.toRepositoryId;
        this.withProperties = builder.withProperties;
        if (this.fromRefIds.size() + this.toRefIds.size() > 100) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not allow searching more than " + 100 + " branches");
        }
    }

    @Nonnull
    public Collection<String> getFromRefIds() {
        return this.fromRefIds;
    }

    @Nullable
    public Integer getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    @Nullable
    public PullRequestOrder getOrder() {
        return this.order;
    }

    @Nonnull
    public Collection<PullRequestParticipantRequest> getParticipants() {
        return this.participants;
    }

    @Nullable
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public Collection<String> getToRefIds() {
        return this.toRefIds;
    }

    @Nullable
    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    public boolean isWithProperties() {
        return this.withProperties;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> fromRefIds = ImmutableSet.builder();
        private final ImmutableList.Builder<PullRequestParticipantRequest> participants = ImmutableList.builder();
        private final ImmutableSet.Builder<String> toRefIds = ImmutableSet.builder();
        private Integer fromRepositoryId;
        private PullRequestOrder order;
        private PullRequestState state;
        private Integer toRepositoryId;
        private boolean withProperties = true;

        @Nonnull
        public PullRequestSearchRequest build() {
            return new PullRequestSearchRequest(this);
        }

        @Nonnull
        public Builder repositoryAndBranch(@Nullable PullRequestDirection direction, @Nullable Integer repositoryId, @Nullable String branch) {
            if (direction == PullRequestDirection.OUTGOING) {
                Builder.addIf(NOT_BLANK, this.fromRefIds, branch);
                if (this.fromRepositoryId != null && !this.fromRepositoryId.equals(repositoryId)) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.fromRepositoryId = repositoryId;
            } else {
                Builder.addIf(NOT_BLANK, this.toRefIds, branch);
                if (this.toRepositoryId != null && !this.toRepositoryId.equals(repositoryId)) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.toRepositoryId = repositoryId;
            }
            return this;
        }

        @Nonnull
        public Builder fromRepositoryId(@Nullable Integer value) {
            this.fromRepositoryId = value;
            return this;
        }

        @Nonnull
        public Builder fromRefId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, value);
            return this;
        }

        @Nonnull
        public Builder fromRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, values);
            return this;
        }

        @Nonnull
        public Builder order(@Nullable PullRequestOrder value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public Builder participant(@Nullable PullRequestParticipantRequest value) {
            Builder.addIf(Objects::nonNull, this.participants, value);
            return this;
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<PullRequestParticipantRequest> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this;
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer value) {
            this.toRepositoryId = value;
            return this;
        }

        @Nonnull
        public Builder toRefId(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.toRefIds, value);
            return this;
        }

        @Nonnull
        public Builder toRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.toRefIds, values);
            return this;
        }

        @Nonnull
        public Builder withProperties(boolean value) {
            this.withProperties = value;
            return this;
        }
    }
}

