/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivityType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;

public class PullRequestActivitySearchRequest
extends AbstractPullRequestRequest {
    private final Set<CommentAction> commentActions;
    private final Set<Long> commentIds;
    private final Set<PullRequestActivityType> types;
    private final boolean withProperties;

    private PullRequestActivitySearchRequest(Builder builder) {
        super(builder);
        this.commentActions = builder.commentActions.build();
        this.commentIds = builder.commentIds.build();
        this.types = builder.types.build();
        this.withProperties = builder.withProperties;
        Preconditions.checkArgument((this.commentActions.isEmpty() || this.types.contains((Object)PullRequestActivityType.COMMENT) ? 1 : 0) != 0, (Object)"The search request specifies comment actions but does not search for comment activities.");
        Preconditions.checkArgument((this.commentIds.isEmpty() || this.types.contains((Object)PullRequestActivityType.COMMENT) ? 1 : 0) != 0, (Object)"The search request specifies comment IDs but does not search for comment activities.");
    }

    @Nonnull
    public Set<CommentAction> getCommentActions() {
        return this.commentActions;
    }

    @Nonnull
    public Set<Long> getCommentIds() {
        return this.commentIds;
    }

    @Nonnull
    public Set<PullRequestActivityType> getTypes() {
        return this.types;
    }

    public boolean isWithProperties() {
        return this.withProperties;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final ImmutableSet.Builder<CommentAction> commentActions = ImmutableSet.builder();
        private final ImmutableSet.Builder<Long> commentIds = ImmutableSet.builder();
        private final ImmutableSet.Builder<PullRequestActivityType> types = ImmutableSet.builder();
        private boolean withProperties;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public PullRequestActivitySearchRequest build() {
            return new PullRequestActivitySearchRequest(this);
        }

        @Nonnull
        public Builder commentActions(@Nullable CommentAction value, CommentAction ... values) {
            Builder.addIf(Objects::nonNull, this.commentActions, value, values);
            return this.self();
        }

        @Nonnull
        public Builder commentActions(@Nullable Iterable<CommentAction> values) {
            Builder.addIf(Objects::nonNull, this.commentActions, values);
            return this.self();
        }

        @Nonnull
        public Builder commentIds(long value, long ... values) {
            this.commentIds.add((Object)value);
            if (values != null && values.length != 0) {
                this.commentIds.add((Object[])ArrayUtils.toObject((long[])values));
            }
            return this.self();
        }

        @Nonnull
        public Builder commentIds(@Nullable Iterable<Long> values) {
            Builder.addIf(Objects::nonNull, this.commentIds, values);
            return this.self();
        }

        @Nonnull
        public Builder types(@Nullable PullRequestActivityType value, PullRequestActivityType ... values) {
            Builder.addIf(Objects::nonNull, this.types, value, values);
            return this.self();
        }

        @Nonnull
        public Builder types(@Nullable Iterable<PullRequestActivityType> values) {
            Builder.addIf(Objects::nonNull, this.types, values);
            return this.self();
        }

        @Nonnull
        public Builder withProperties(boolean value) {
            this.withProperties = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

