/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.property.SimplePropertySupport;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.Person;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleCommit
extends SimpleMinimalCommit
implements Commit,
Serializable {
    private final Person author;
    private final Date authorTimestamp;
    private final String message;
    private final List<MinimalCommit> parents;
    private transient SimplePropertySupport propertySupport;
    private transient Repository repository;

    private SimpleCommit(Builder builder) {
        super(builder.minimalCommitBuilder);
        this.propertySupport = new SimplePropertySupport(builder);
        this.author = builder.author;
        this.authorTimestamp = builder.authorTimestamp;
        this.message = builder.message;
        this.parents = ImmutableList.copyOf((Collection)builder.parents);
        this.repository = builder.repository;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof SimpleCommit) {
            SimpleCommit that = (SimpleCommit)o;
            return Objects.equals(this.getAuthor(), that.getAuthor()) && Objects.equals(this.getAuthorTimestamp(), that.getAuthorTimestamp()) && Objects.equals(this.getMessage(), that.getMessage());
        }
        return false;
    }

    @Override
    @Nonnull
    public PropertyMap getProperties() {
        return this.propertySupport.getProperties();
    }

    @Override
    @Nonnull
    public Person getAuthor() {
        return this.author;
    }

    @Override
    @Nonnull
    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public List<MinimalCommit> getParents() {
        return this.parents;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId(), this.getAuthor(), this.getAuthorTimestamp(), this.getMessage());
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        this.propertySupport.setProperties(properties);
    }

    public void setRepository(Repository repository) {
        if (this.repository != null) {
            throw new IllegalStateException("Repository has already been set; you cannot override once set.");
        }
        this.repository = repository;
    }

    @Override
    public String toString() {
        return "SimpleCommit{id='" + this.getId() + "', author='" + this.getAuthor() + "', authorTimestamp=" + this.getAuthorTimestamp() + ", message='" + this.getMessage() + "'}";
    }

    public static final class Builder
    extends SimplePropertySupport.AbstractPropertyBuilder<Builder> {
        private final SimpleMinimalCommit.Builder minimalCommitBuilder;
        private Person author;
        private Date authorTimestamp;
        private String message;
        private List<MinimalCommit> parents;
        private Repository repository;

        public Builder(@Nonnull String id) {
            this.minimalCommitBuilder = new SimpleMinimalCommit.Builder(id);
            this.parents = new ArrayList<MinimalCommit>();
        }

        public Builder(@Nonnull Commit commit) {
            super(commit);
            this.author = commit.getAuthor();
            this.authorTimestamp = commit.getAuthorTimestamp();
            this.message = commit.getMessage();
            this.minimalCommitBuilder = new SimpleMinimalCommit.Builder(commit);
            this.parents = new ArrayList<MinimalCommit>(commit.getParents());
            this.repository = commit.getRepository();
        }

        @Nonnull
        public Builder author(Person value) {
            this.author = value;
            return this.self();
        }

        @Nonnull
        public Builder authorTimestamp(Date value) {
            this.authorTimestamp = value != null ? new Date(value.getTime()) : null;
            return this.self();
        }

        @Nonnull
        public SimpleCommit build() {
            return new SimpleCommit(this);
        }

        @Nonnull
        public Builder clearParents() {
            this.parents.clear();
            return this.self();
        }

        @Nonnull
        public Builder displayId(@Nullable String value) {
            this.minimalCommitBuilder.displayId(value);
            return this.self();
        }

        @Nonnull
        public Builder message(String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder parent(MinimalCommit value) {
            Builder.addIf(Objects::nonNull, this.parents, value);
            return this.self();
        }

        @Nonnull
        public Builder parents(MinimalCommit value, MinimalCommit ... values) {
            Builder.addIf(Objects::nonNull, this.parents, value, values);
            return this.self();
        }

        @Nonnull
        public Builder parents(Iterable<MinimalCommit> values) {
            Builder.addIf(Objects::nonNull, this.parents, values);
            return this.self();
        }

        @Nonnull
        public Builder repository(@Nullable Repository value) {
            this.repository = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

