/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.TrustedCreate;
import com.atlassian.bitbucket.validation.groups.TrustedUpdate;
import com.atlassian.bitbucket.validation.groups.Update;
import javax.annotation.Nonnull;
import javax.validation.constraints.Pattern;

public interface Project {
    public static final String KEY_REGEXP = "[a-zA-Z][a-zA-Z0-9_\\-]*";
    public static final String KEY_TRUSTED_REGEXP = "~?[a-zA-Z][a-zA-Z0-9_\\-]*";
    public static final int MAX_KEY_LENGTH = 128;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final String NAMESPACE_REGEXP = "[a-zA-Z0-9_\\-]*";

    public <T> T accept(@Nonnull ProjectVisitor<T> var1);

    @OptionalString(size=255)
    public String getDescription();

    public int getId();

    public boolean isPublic();

    @Pattern.List(value={@Pattern(regexp="[a-zA-Z][a-zA-Z0-9_\\-]*", groups={Create.class, Update.class}, message="{com.atlassian.bitbucket.validation.project.key.pattern.message}"), @Pattern(regexp="~?[a-zA-Z][a-zA-Z0-9_\\-]*", groups={TrustedCreate.class, TrustedUpdate.class}, message="{com.atlassian.bitbucket.validation.project.key.trusted.pattern.message}")})
    @RequiredString(size=128)
    public String getKey();

    @RequiredString(size=128)
    public String getName();

    @Pattern(regexp="[a-zA-Z0-9_\\-]*", message="{com.atlassian.bitbucket.validation.project.namespace.pattern.message}")
    @OptionalString(size=128)
    public String getNamespace();

    @Nonnull
    public ProjectType getType();
}

