/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractProjectRequest {
    private final String description;
    private final String key;
    private final String name;
    private final String namespace;
    private final boolean publiclyAccessible;

    @Deprecated
    protected AbstractProjectRequest(String key, String name, String description, boolean publiclyAccessible) {
        this.description = description;
        this.name = name;
        this.namespace = null;
        this.key = key;
        this.publiclyAccessible = publiclyAccessible;
    }

    protected AbstractProjectRequest(AbstractBuilder builder) {
        this.description = builder.description;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.key = builder.key;
        this.publiclyAccessible = builder.publiclyAccessible;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder>
    extends BuilderSupport {
        @Deprecated
        protected String description;
        @Deprecated
        protected String key;
        @Deprecated
        protected String name;
        @Deprecated
        protected boolean publiclyAccessible;
        private String namespace;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(@Nonnull Project project) {
            this.description = ((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getDescription();
            this.key = project.getKey();
            this.name = project.getName();
            this.namespace = project.getNamespace();
            this.publiclyAccessible = project.isPublic();
        }

        @Nonnull
        public B description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        @Nonnull
        public B key(@Nonnull String value) {
            this.key = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String value) {
            this.name = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
            return this.self();
        }

        @Nonnull
        public B namespace(@Nullable String value) {
            this.namespace = value;
            return this.self();
        }

        @Nonnull
        public B publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

