/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ProjectSearchRequest {
    private final String name;
    private final Permission permission;

    private ProjectSearchRequest(String name, Permission permission) {
        this.name = StringUtils.trimToNull((String)name);
        this.permission = permission;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Permission getPermission() {
        return this.permission;
    }

    public boolean hasName() {
        return StringUtils.isNotBlank((CharSequence)this.getName());
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public static class Builder {
        private String name;
        private Permission permission;

        public Builder() {
        }

        public Builder(@Nonnull ProjectSearchRequest request) {
            this.name = ((ProjectSearchRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getName();
            this.permission = request.getPermission();
        }

        @Nonnull
        public ProjectSearchRequest build() {
            return new ProjectSearchRequest(this.name, this.permission);
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public Builder permission(@Nullable Permission value) {
            Preconditions.checkArgument((value == null || value.isResource(Project.class) ? 1 : 0) != 0, (Object)"The provided permission is not valid for projects");
            this.permission = value;
            return this;
        }
    }
}

