/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.compare;

import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.content.AbstractDiffRequest;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class CompareDiffRequest
extends AbstractDiffRequest {
    private final CompareRef fromRef;
    private final CompareRef toRef;

    private CompareDiffRequest(Builder builder) {
        super(builder);
        this.fromRef = builder.fromRef;
        this.toRef = builder.toRef;
    }

    @Nonnull
    public CompareRef getFromRef() {
        return this.fromRef;
    }

    @Nonnull
    public CompareRef getToRef() {
        return this.toRef;
    }

    public static class Builder
    extends AbstractDiffRequest.AbstractBuilder<Builder, CompareDiffRequest> {
        private CompareRef fromRef;
        private CompareRef toRef;

        @Override
        @Nonnull
        public CompareDiffRequest build() {
            Preconditions.checkArgument((this.fromRef != null && this.toRef != null ? 1 : 0) != 0, (Object)"Both fromRef and toRef are required.");
            return new CompareDiffRequest(this);
        }

        @Nonnull
        public Builder fromRef(CompareRef value) {
            this.fromRef = (CompareRef)Preconditions.checkNotNull((Object)value, (Object)"fromRef");
            return this.self();
        }

        @Nonnull
        public Builder toRef(CompareRef value) {
            this.toRef = (CompareRef)Preconditions.checkNotNull((Object)value, (Object)"toRef");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

